/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.common.items.SimpleSubItemClass;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MathUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_THTR
extends GT_MetaTileEntity_MultiBlockBase {
    private static final int BASECASINGINDEX = 44;
    private static final int HELIUM_NEEDED = 730000;
    private int HeliumSupply;
    private int BISOPeletSupply;
    private int savedBISO;
    private int TRISOPeletSupply;
    private int savedTRISO;
    private boolean empty;

    public GT_TileEntity_THTR(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private GT_TileEntity_THTR(String aName) {
        super(aName);
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.HeliumSupply = aNBT.func_74762_e("HeliumSupply");
        this.BISOPeletSupply = aNBT.func_74762_e("BISOPeletSupply");
        this.TRISOPeletSupply = aNBT.func_74762_e("TRISOPeletSupply");
        this.savedBISO = aNBT.func_74762_e("savedBISO");
        this.savedTRISO = aNBT.func_74762_e("savedTRISO");
        this.empty = aNBT.func_74767_n("EmptyMode");
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("HeliumSupply", this.HeliumSupply);
        aNBT.func_74768_a("BISOPeletSupply", this.BISOPeletSupply);
        aNBT.func_74768_a("TRISOPeletSupply", this.TRISOPeletSupply);
        aNBT.func_74768_a("savedBISO", this.savedBISO);
        aNBT.func_74768_a("savedTRISO", this.savedTRISO);
        aNBT.func_74757_a("EmptyMode", this.empty);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.HeliumSupply < 730000) {
                for (FluidStack fluidStack : this.getStoredFluids()) {
                    if (!fluidStack.isFluidEqual(Materials.Helium.getGas(1000L))) continue;
                    while (this.HeliumSupply < 730000 && fluidStack.amount > 0) {
                        ++this.HeliumSupply;
                        --fluidStack.amount;
                    }
                }
            }
            for (ItemStack itemStack : this.getStoredInputs()) {
                if (GT_Utility.areStacksEqual((ItemStack)itemStack, (ItemStack)new ItemStack((Item)THTRMaterials.aTHTR_Materials, 1, 3))) {
                    if (this.BISOPeletSupply + this.TRISOPeletSupply >= 675000) continue;
                    while (this.BISOPeletSupply + this.TRISOPeletSupply < 675000 && itemStack.field_77994_a > 0) {
                        --itemStack.field_77994_a;
                        ++this.TRISOPeletSupply;
                    }
                    this.updateSlots();
                    continue;
                }
                if (!GT_Utility.areStacksEqual((ItemStack)itemStack, (ItemStack)new ItemStack((Item)THTRMaterials.aTHTR_Materials, 1, 1)) || this.BISOPeletSupply + this.TRISOPeletSupply >= 675000) continue;
                while (this.BISOPeletSupply + this.TRISOPeletSupply < 675000 && itemStack.field_77994_a > 0) {
                    --itemStack.field_77994_a;
                    ++this.BISOPeletSupply;
                }
                this.updateSlots();
            }
        }
    }

    public boolean checkRecipe(ItemStack controllerStack) {
        if (this.HeliumSupply < 730000 || this.BISOPeletSupply + this.TRISOPeletSupply < 100000) {
            return false;
        }
        this.reduceSupply();
        this.addBurnedOutBalls();
        this.updateSlots();
        this.mOutputFluids = new FluidStack[]{FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)0)};
        this.mEUt = 0;
        this.mMaxProgresstime = 648000;
        return true;
    }

    private void reduceSupply() {
        int toReduce = new XSTR().nextInt(MathUtils.floorInt(((double)this.BISOPeletSupply + (double)this.TRISOPeletSupply) / 200.0));
        this.savedBISO = this.BISOPeletSupply;
        this.savedTRISO = this.TRISOPeletSupply;
        if (new XSTR().nextBoolean()) {
            if (this.BISOPeletSupply > 0) {
                this.BISOPeletSupply -= toReduce;
            } else {
                this.TRISOPeletSupply -= toReduce;
            }
        } else if (this.TRISOPeletSupply > 0) {
            this.TRISOPeletSupply -= toReduce;
        } else {
            this.BISOPeletSupply -= toReduce;
        }
    }

    private void addBurnedOutBalls() {
        int burnedTRISO = this.savedTRISO - this.TRISOPeletSupply;
        int burnedBISO = this.savedBISO - this.BISOPeletSupply;
        int burnedTRISOBall = burnedTRISO / 64;
        int burnedBISOBall = burnedBISO / 64;
        this.mOutputItems = new ItemStack[]{new ItemStack((Item)THTRMaterials.aTHTR_Materials, burnedTRISOBall, 6), new ItemStack((Item)THTRMaterials.aTHTR_Materials, burnedTRISO -= burnedTRISOBall * 64, 8), new ItemStack((Item)THTRMaterials.aTHTR_Materials, burnedBISOBall, 7), new ItemStack((Item)THTRMaterials.aTHTR_Materials, burnedBISO -= burnedBISOBall * 64, 9)};
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.empty) {
            this.addOutput(Materials.Helium.getGas((long)this.HeliumSupply));
            this.addOutput(new ItemStack((Item)THTRMaterials.aTHTR_Materials, this.TRISOPeletSupply, 3));
            this.addOutput(new ItemStack((Item)THTRMaterials.aTHTR_Materials, this.BISOPeletSupply, 1));
            this.HeliumSupply = 0;
            this.TRISOPeletSupply = 0;
            this.BISOPeletSupply = 0;
            this.savedTRISO = 0;
            this.savedBISO = 0;
            return true;
        }
        long accessibleCoolant = 0L;
        for (FluidStack fluidStack : this.getStoredFluids()) {
            if (!fluidStack.isFluidEqual(FluidRegistry.getFluidStack((String)"ic2coolant", (int)1))) continue;
            accessibleCoolant += (long)fluidStack.amount;
        }
        accessibleCoolant = Math.min((long)(0.0071111111111111115 * (double)this.savedTRISO + 0.004740740740740741 * (double)this.savedBISO), accessibleCoolant);
        for (FluidStack fluidStack : this.getStoredFluids()) {
            if (!fluidStack.isFluidEqual(FluidRegistry.getFluidStack((String)"ic2coolant", (int)1))) continue;
            if (accessibleCoolant >= (long)fluidStack.amount) {
                accessibleCoolant -= (long)fluidStack.amount;
                fluidStack.amount = 0;
                continue;
            }
            if (accessibleCoolant <= 0L) continue;
            fluidStack.amount = (int)((long)fluidStack.amount - accessibleCoolant);
            accessibleCoolant = 0L;
        }
        this.mOutputFluids[0].amount = (int)((long)this.mOutputFluids[0].amount + accessibleCoolant);
        this.updateSlots();
        return true;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        int xz = 5;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * xz;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * xz;
        for (int x = -xz; x <= xz; ++x) {
            for (int z = -xz; z <= xz; ++z) {
                for (int y = 0; y < 12; ++y) {
                    if (!(y == 0 || y == 11 ? !(Math.abs(z) == xz - 1 && Math.abs(x) == xz || Math.abs(z) == xz && Math.abs(x) == xz - 1 || Math.abs(x) == Math.abs(z) && Math.abs(x) == xz || x + xDir == 0 && y == 0 && z + zDir == 0 || aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z) == GregTech_API.sBlockCasings3 && aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z) == 12 || this.addInputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), 44) && y == 11 || this.addOutputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), 44) && y == 0 || this.addMaintenanceToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), 44)) : !(Math.abs(z) == xz - 1 && Math.abs(x) == xz || Math.abs(z) == xz && Math.abs(x) == xz - 1 || Math.abs(x) == Math.abs(z) && Math.abs(x) == xz || Math.abs(x) < xz && Math.abs(z) != xz || aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z) == GregTech_API.sBlockCasings3 && aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z) == 12 || this.addMaintenanceToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), 44)))) continue;
                    return false;
                }
            }
        }
        return this.mMaintenanceHatches.size() == 1;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_THTR(this.mName);
    }

    public String[] getInfoData() {
        return new String[]{"Progress:", this.mProgresstime / 20 + "secs", this.mMaxProgresstime / 20 + "secs", "BISO-Pebbles:", this.BISOPeletSupply + "pcs.", "TRISO-Pebbles:", this.TRISOPeletSupply + "pcs.", "Helium-Level:", this.HeliumSupply + "L / " + 730000 + "L", "Coolant/t:", this.savedBISO + this.savedTRISO >= 100000 ? (long)(0.0071111111111111115 * (double)this.savedTRISO + 0.004740740740740741 * (double)this.savedBISO) + "L/t" : "0L/t", "Problems:", String.valueOf(this.getIdealStatus() - this.getRepairStatus())};
    }

    public String[] getDescription() {
        return BW_Tooltip_Reference.getTranslatedBrandedTooltip("tooltip.tile.htr.0.name");
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aSide == aFacing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.getCasingTextureForId((int)44);
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = TextureFactory.of((ITexture[])new ITexture[]{aActive ? TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW}).glow().build()}) : TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW}).glow().build()})});
        } else {
            ITexture[] iTextureArray3 = new ITexture[1];
            iTextureArray = iTextureArray3;
            iTextureArray3[0] = Textures.BlockIcons.getCasingTextureForId((int)44);
        }
        return iTextureArray;
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.empty = !this.empty;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(this.empty ? "THTR will now empty itself." : "THTR is back in normal Operation"));
    }

    public static class THTRMaterials {
        static final SimpleSubItemClass aTHTR_Materials = new SimpleSubItemClass("BISOPelletCompound", "BISOPellet", "TRISOPelletCompound", "TRISOPellet", "BISOPelletBall", "TRISOPelletBall", "BurnedOutBISOPelletBall", "BurnedOutTRISOPelletBall", "BurnedOutBISOPellet", "BurnedOutTRISOPellet");

        public static void registeraTHR_Materials() {
            GameRegistry.registerItem((Item)aTHTR_Materials, (String)"bw.THTRMaterials");
        }

        public static void registerTHR_Recipes() {
            GT_Values.RA.addCentrifugeRecipe(Materials.Thorium.getDust(1), GT_Values.NI, GT_Values.NF, GT_Values.NF, Materials.Thorium.getDustSmall(2), Materials.Thorium.getDustSmall(1), WerkstoffLoader.Thorium232.get(OrePrefixes.dustTiny, 1), WerkstoffLoader.Thorium232.get(OrePrefixes.dustTiny, 1), WerkstoffLoader.Thorium232.get(OrePrefixes.dustTiny, 1), Materials.Lutetium.getDustTiny(1), new int[]{1600, 1500, 200, 200, 50, 50}, 10000, BW_Util.getMachineVoltageFromTier(4));
            GT_Values.RA.addAssemblerRecipe(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.Lead, (long)6L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.TungstenSteel, (long)1L)}, Materials.Concrete.getMolten(1296L), new ItemStack(GregTech_API.sBlockCasings3, 1, 12), 40, BW_Util.getMachineVoltageFromTier(5));
            GT_Values.RA.addMixerRecipe(WerkstoffLoader.Thorium232.get(OrePrefixes.dust, 10), Materials.Uranium235.getDust(1), GT_Utility.getIntegratedCircuit((int)1), null, null, null, new ItemStack((Item)aTHTR_Materials), 400, 30);
            GT_Values.RA.addFormingPressRecipe(new ItemStack((Item)aTHTR_Materials), Materials.Graphite.getDust(64), new ItemStack((Item)aTHTR_Materials, 1, 4), 40, 30);
            Object[] pellets = new ItemStack[6];
            Arrays.fill(pellets, new ItemStack((Item)aTHTR_Materials, 64, 1));
            GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.addRecipe(false, new ItemStack[]{new ItemStack((Item)aTHTR_Materials, 1, 4), GT_Utility.getIntegratedCircuit((int)17)}, (ItemStack[])pellets, null, null, null, null, 24000, 30, 0);
            GT_Values.RA.addFormingPressRecipe(new ItemStack((Item)aTHTR_Materials, 1, 4), Materials.Silicon.getDust(64), new ItemStack((Item)aTHTR_Materials, 1, 2), 40, 30);
            GT_Values.RA.addFormingPressRecipe(new ItemStack((Item)aTHTR_Materials, 1, 2), Materials.Graphite.getDust(64), new ItemStack((Item)aTHTR_Materials, 1, 5), 40, 30);
            pellets = new ItemStack[6];
            Arrays.fill(pellets, new ItemStack((Item)aTHTR_Materials, 64, 3));
            GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.addRecipe(false, new ItemStack[]{new ItemStack((Item)aTHTR_Materials, 1, 5), GT_Utility.getIntegratedCircuit((int)17)}, (ItemStack[])pellets, null, null, null, null, 48000, 30, 0);
            GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.addRecipe(false, new ItemStack[]{new ItemStack((Item)aTHTR_Materials, 1, 6), GT_Utility.getIntegratedCircuit((int)17)}, new ItemStack[]{new ItemStack((Item)aTHTR_Materials, 64, 8)}, null, null, null, null, 48000, 30, 0);
            GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.addRecipe(false, new ItemStack[]{new ItemStack((Item)aTHTR_Materials, 1, 7), GT_Utility.getIntegratedCircuit((int)17)}, new ItemStack[]{new ItemStack((Item)aTHTR_Materials, 64, 9)}, null, null, null, null, 48000, 30, 0);
            GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.addRecipe(false, new ItemStack[]{new ItemStack((Item)aTHTR_Materials, 1, 8)}, new ItemStack[]{Materials.Lutetium.getDustSmall(2)}, null, null, null, null, 1200, 30, 0);
            GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.addRecipe(false, new ItemStack[]{new ItemStack((Item)aTHTR_Materials, 1, 9)}, new ItemStack[]{Materials.Lutetium.getDustSmall(4)}, null, null, null, null, 1200, 30, 0);
        }
    }
}

